using System;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.Client
{
	/// <summary>
	/// This exception is thrown when network problems are preventing 
	/// normal VistALink functioning.
	/// </summary>
	public class VistALinkNetworkErrorException : VistALinkException
	{
		/// <summary>
		/// Default constructor. Error message is self-contained and cannot be changed.
		/// </summary>
		public VistALinkNetworkErrorException()
			: base() {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public VistALinkNetworkErrorException( string message ) 
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public VistALinkNetworkErrorException( string message, Exception innerException )
			: base( message, innerException ) {}
	}
}
